<?php
/*-------------------------------------------------------+
| PHP-Fusion Content Management System
| Copyright (C) 2002 - 2008 Nick Jones
| http://www.php-fusion.co.uk/
+--------------------------------------------------------+
| User Threads List
| Filename: user_posts.php
| Author: Paul Beuk (a.k.a. muscapaul)
| email: muscapaul@gmail.com
| web: http://www.muscapaul.com
+--------------------------------------------------------+
| This program is released as free software under the
| Affero GPL license. You can redistribute it and/or
| modify it under the terms of this license which you
| can read by viewing the included agpl.txt or online
| at www.gnu.org/licenses/agpl.html. Removal of this
| copyright header is strictly prohibited without
| written permission from the original author(s).
+--------------------------------------------------------*/
require_once "../../maincore.php";
require_once THEMES."templates/admin_header.php";

if (file_exists(INFUSIONS."user_threads_list/locale/".$settings['locale'].".php")) {
	include INFUSIONS."user_threads_list/locale/".$settings['locale'].".php";
} else {
	include INFUSIONS."user_threads_list/locale/English.php";
include LOCALE.LOCALESET."forum/main.php";
}
if (!checkrights("M") || !defined("iAUTH") || $_GET['aid'] != iAUTH) { redirect("../index.php"); }

$user_id = (isset($_REQUEST['user_id']) AND isnum($_REQUEST['user_id'])) ? $_REQUEST['user_id'] : "";
$rowstart = (isset($_REQUEST['rowstart']) AND isnum($_REQUEST['rowstart'])) ? $_REQUEST['rowstart'] : "0";

$result = dbquery("SELECT tp.*, tf.*, tt.* FROM ".DB_POSTS." tp INNER JOIN ".DB_FORUMS." tf USING(forum_id) INNER JOIN ".DB_THREADS." tt USING(thread_id) WHERE post_author = '$user_id'");
$rows = dbrows($result);
if ($rows != 0) {
	$result = dbquery(
		"SELECT tp.forum_id, tp.thread_id, tp.post_id, tp.post_author, tp.post_datestamp,
		tf.forum_name, tf.forum_access, tt.thread_subject
		FROM ".DB_POSTS." tp
		INNER JOIN ".DB_FORUMS." tf ON tp.forum_id=tf.forum_id
		INNER JOIN ".DB_THREADS." tt ON tp.thread_id=tt.thread_id
		WHERE ".groupaccess('tf.forum_access')." AND tp.post_author='".$user_id."'
		ORDER BY tp.post_datestamp DESC LIMIT ".$rowstart.",20"
	);

	$i = 0;
	opentable($locale['uft131']);
	echo "<table width='100%' cellpadding='0' cellspacing='1' class='tbl-border'>\n" ;
	echo "<tr><td style='text-align:center;' class='tbl2'>&nbsp;</td>";
	echo "<td style='text-align:left;' width='180' class='tbl2'><span class='small'><b>".$locale['global_048']."</b></span></td>";
	echo "<td style='text-align:center;' class='tbl2'><span class='small'><b>".$locale['uft133']."</b></span></td>";
	echo "<td style='text-align:center;' width='100' class='tbl2'><span class='small'><b>".$locale['global_049']."</b></span></td></tr>\n";
	while ($data = dbarray($result)) {
		if ($i % 2 == 0) { $row_color = "tbl1"; } else { $row_color = "tbl2"; }
		$reply_count = dbcount("(thread_id)", DB_POSTS, "thread_id = '".$data['thread_id']."'");
		$rstart = ($reply_count > 20 ? "rowstart=".((ceil($reply_count / 20)-1)*20)."&amp;" : "");
		echo "<tr><td class='tbl1'><img border='0' src='".THEME."forum/folder.gif'></td>";
		echo "<td width='180' class='$row_color'><span class='small'>".trimlink($data['forum_name'], 30)."</span></td>";
		echo "<td class='$row_color'><span class='small'><a href='".FORUM."viewthread.php?".$rstart."forum_id=".$data['forum_id']."&amp;thread_id=".$data['thread_id']."#post_".$data['post_id']."' title='".$data['thread_subject']."'>".trimlink($data['thread_subject'], 40)."</a></span></td>";
		echo "<td style='text-align:center;' width='115' class='$row_color'><span class='small'>".showdate("forumdate", $data['post_datestamp'])."</span></td></tr>\n";
		$i++;
		}
	echo "</table>\n";
	closetable();
	echo "<div align='center' style='margin-top:5px;'>\n".makePageNav($rowstart,20,$rows,3,FUSION_SELF.$aidlink."&user_id=".$user_id."&")."\n</div>\n";
} 
else {
	opentable($locale['uft131']);
	echo "<table width='100%' cellpadding='0' cellspacing='1' class='tbl-border'>\n";
	echo "<td><td style='text-align:center;' class='tbl1'>".$locale['uft132']."</td></tr>";
	echo "</table>";
	closetable();
}

require_once THEMES."templates/footer.php";
?>
