<?php
/*-------------------------------------------------------+
| PHP-Fusion Content Management System
| Copyright (C) 2002 - 2009 Nick Jones
| http://www.php-fusion.co.uk/
+--------------------------------------------------------+
| Filename: search_terms_include.php
| Author: Robert Gaudyn (Wooya)
| Modification for Terms: Paul Beuk (muscapaul)
+--------------------------------------------------------+
| This program is released as free software under the
| Affero GPL license. You can redistribute it and/or
| modify it under the terms of this license which you
| can read by viewing the included agpl.txt or online
| at www.gnu.org/licenses/agpl.html. Removal of this
| copyright header is strictly prohibited without
| written permission from the original author(s).
+--------------------------------------------------------*/
if (!defined("IN_FUSION")) { die("Access Denied"); }

include LOCALE.LOCALESET."search/terms.php";
include INFUSIONS."terms/infusion_db.php";

if ($_GET['stype']  ==  "terms" || $_GET['stype'] == "all") {
	if ($_GET['sort'] == "datestamp") {
		$sortby = "term_datestamp";
	} else if ($_GET['sort'] == "subject") {
		$sortby = "term_title";
	} else {
		$sortby = "term_datestamp";
	}
	$ssubject = search_querylike("term_title");
	$smessage = search_querylike("term_descript");
	$surllink = search_querylike("weblink_url");
	if ($_GET['fields'] == 0) {
		$fieldsvar = search_fieldsvar($ssubject);
	} else if ($_GET['fields'] == 1) {
		$fieldsvar = search_fieldsvar($smessage);
	} else if ($_GET['fields'] == 2) {
		$fieldsvar = search_fieldsvar($ssubject, $smessage);
	}
	$result = dbquery(
		"SELECT tw.*,twc.* FROM ".DB_TERMS." tw
		INNER JOIN ".DB_TERM_CATS." twc ON tw.term_cat=twc.term_cat_id
		WHERE ".groupaccess('term_cat_access')." AND ".$fieldsvar."
		".($_GET['datelimit'] != 0 ?" AND term_datestamp>=".(time()-$_GET['datelimit']):"")
	);
	$rows = dbrows($result);
	if ($rows != 0) {
		$items_count .= THEME_BULLET."&nbsp;<a href='".FUSION_SELF."?stype=terms&amp;stext=".$_GET['stext']."&amp;".$composevars."'>".$rows." ".($rows == 1 ? $locale['w401'] : $locale['w402'])." ".$locale['522']."</a><br />\n";
		$result = dbquery(
			"SELECT tw.*,twc.* FROM ".DB_TERMS." tw
			INNER JOIN ".DB_TERM_CATS." twc ON tw.term_cat=twc.term_cat_id
			WHERE ".groupaccess('term_cat_access')." AND ".$fieldsvar."
			".($_GET['datelimit'] != 0 ? " AND term_datestamp>=".(time() - $_GET['datelimit']) : "")."
			ORDER BY ".$sortby." ".($_GET['order'] == 1 ? "ASC" : "DESC").($_GET['stype']!="all"?" LIMIT ".$_GET['rowstart'].",10" : "")
		);
		while ($data = dbarray($result)) {
			$search_result = "";
			if ($data['term_datestamp']+604800 > time()+($settings['timeoffset']*3600)) {
				$new = " <span class='small'>".$locale['w403']."</span>";
			} else {
				$new = "";
			}
			$text_all = $data['term_descript'];
			$text_all = search_striphtmlbbcodes($text_all);
			$text_frag = search_textfrag($text_all);
			$text_frag = highlight_words($swords, $text_frag);
			$subj_c = search_stringscount($data['term_title']);
			$text_c = search_stringscount($data['term_descript']);

			$search_result .= "<a href='".INFUSIONS."terms/terms.php?op=view&amp;id=".$data['term_id']."' target='_blank'>".highlight_words($swords, $data['term_title'])."</a> (".$data['term_cat_name'].") ".$new."<br /><br />\n";
			if ($text_frag != "") { $search_result .= "<div class='quote' style='width:auto;height:auto;overflow:auto'>".$text_frag."</div><br />"; }
			$search_result .= "<span class='small'><font class='alt'>".$locale['w404']."</font> ".showdate("%d.%m.%y", $data['term_datestamp'])."</span><br /><br />\n";
			search_globalarray($search_result);
		}
	} else {
		$items_count .= THEME_BULLET."&nbsp;0 ".$locale['w402']." ".$locale['522']."<br />\n";
	}
	$navigation_result = search_navigation($rows);
}
?>