<?php
/*---------------------------------------------------+
| PHP-Fusion 7 Content Management System
| Copyright  2002 - 2008 Nick Jones
| http://www.php-fusion.co.uk/
+----------------------------------------------------+
| Filename: parse_functions.php
| Author: Paul Beuk a.k.a. muscapaul
| Terms Infusion (Dictionary/Glossary)
| muscapaul@gmail.com / http://www.muscapaul.com
| Copyright  2008-2009
+----------------------------------------------------+
| This program is released as free software under the
| Affero GPL license. You can redistribute it and/or
| modify it under the terms of this license which you
| can read by viewing the included agpl.txt or online
| at www.gnu.org/licenses/agpl.html. Removal of this
| copyright header is strictly prohibited without
| written permission from the original author(s).
+----------------------------------------------------*/
if (!defined("IN_FUSION")) { die("Access Denied"); }

include INFUSIONS."terms/infusion_db.php";

// Parse text to replace term title with term description and strip url bbcode from text
function parseterm($text) {
	global $settings;

	$dsettings = dbarray(dbquery("SELECT * FROM ".DB_PREFIX."term_settings"));
	$type = $dsettings['term_type'];
	if (file_exists(INFUSIONS."terms/".$type."locale/".$settings['locale'].".php")) {
		include INFUSIONS."terms/".$type."locale/".$settings['locale'].".php";
	}
	else {
		include INFUSIONS."terms/".$type."locale/English.php";
	}

	$result_a = dbquery("SELECT term_title, term_descript FROM ".DB_PREFIX."terms ORDER BY term_id ASC");
	$termrows = dbrows($result_a);
	if ($termrows != '0') {
		$search_s = '';
		$terms_s = '';
		while ($data_a=dbarray($result_a)) {
			$result_b = dbquery("SELECT term_title FROM ".DB_PREFIX."terms WHERE term_title = '".$data_a['term_title']."'");
			$rowsb = dbrows($result_b);
			$search_s .= "'-expl-".$data_a['term_title']."-expl-', ";
			if ($rowsb != 1) {
				$terms_s .= "".$locale['term805']."_ ";
			}
			else {
				$terms_s .= "".$data_a['term_descript']."_ ";
			}
		}
		$search_a = substr($search_s, 0, -2);
		$terms_a = substr($terms_s, 0, -2);
		$search = explode(', ', $search_a);
		$terms = explode ('_ ', $terms_a);
		$text = preg_replace($search, $terms, $text);
	}
	$text = preg_replace('#\[b\](.*?)\[/b\]#si', '\1', $text);
	$text = preg_replace('#\[i\](.*?)\[/i\]#si', '\1', $text);
	$text = preg_replace('#\[u\](.*?)\[/u\]#si', '\1', $text);
	$text = preg_replace('#\[center\](.*?)\[/center\]#si', '\1', $text);
	$text = preg_replace('#\[code\](.*?)\[/code\]#si', '\1', $text);
	$text = preg_replace('#\[quote\](.*?)\[/quote\]#si', '\1', $text);
	$text = preg_replace('#\[small\](.*?)\[/small\]#si', '\1', $text);
	$text = preg_replace('#\[url\](.*?)\[/url\]#si', '\1', $text);
	$text = preg_replace('#\[url=([\r\n]*)(http://|ftp://|https://|ftps://)([^\s\'\";\+]*?)\](.*?)([\r\n]*)\[/url\]#si', '\4 (\2\3)', $text);
	$text = preg_replace('#\[url=([\r\n]*)([^\s\'\";\+]*?)\](.*?)([\r\n]*)\[/url\]#si', '\3 (\2)', $text);
	$text = preg_replace('#\[img\](.*?)\[/img\]#si', '\1', $text);
	$text = preg_replace('#\-expl-(.*?)\-expl-#si', $locale['term806'], $text);
	$text = descript($text,false);

	return $text;
}

// Parse text to replace term title with term image
function parsetermimg($text) {
	$result_a = dbquery("SELECT term_title, term_image FROM ".DB_PREFIX."terms ORDER BY term_id ASC");
	$termrows = dbrows($result_a);
	if ($termrows != '0') {
		$search_s = '';
		$images_s = '';
		while ($data_a=dbarray($result_a)) {
			$result_b = dbquery("SELECT term_title FROM ".DB_PREFIX."terms WHERE term_title = '".$data_a['term_title']."'");
			$rowsb = dbrows($result_b);
			$search_s .= "'-imag-".$data_a['term_title']."-imag-', ";
			if ($data_a['term_image'] == '' || $rowsb != 1) {
				$images_s .= "".INFUSIONS."/terms/images/no_image.gif, ";
			}
			else {
				$images_s .= "".$data_a['term_image'].", ";
			}
		}
		$search_a = substr($search_s, 0, -2);
		$images_a = substr($images_s, 0, -2);
		$search = explode(', ', $search_a);
		$images = explode (', ', $images_a);
		$text = preg_replace($search, $images, $text);
	}
	$text = preg_replace('#\-imag-(.*?)\-imag-#si', INFUSIONS."/terms/images/no_image.gif", $text);
	$text = preg_replace('#\[glos\](.*?)\[/glos\]#si', '\1', $text);
	$text = descript($text,false);

	return $text;
}
// Parse text to correct square bracket display
function addsquarebrackets($text) {
	$text = str_replace('&amp;#9', '&#9', $text);
//	$text = replace(' ', '%20');
	
	$text = descript($text,false);

	return $text;
}

?>