<?php
/*---------------------------------------------------+
| PHP-Fusion 7 Content Management System
| Copyright  2002 - 2008 Nick Jones
| http://www.php-fusion.co.uk/
+----------------------------------------------------+
| Copyright  2008 muscapaul
| Terms Infusion (Dictionary/Glossary)
| by muscapaul
| muscapaul@gmail.com / http://www.muscapaul.com
+----------------------------------------------------+
| This program is released as free software under the
| Affero GPL license. You can redistribute it and/or
| modify it under the terms of this license which you
| can read by viewing the included agpl.txt or online
| at www.gnu.org/licenses/agpl.html. Removal of this
| copyright header is strictly prohibited without
| written permission from the original author(s).
+----------------------------------------------------*/

require_once "../../maincore.php";
require_once THEMES."templates/header.php";

include INFUSIONS."terms/infusion_db.php";

$dsettings = dbarray(dbquery("SELECT * FROM ".DB_TERM_SETTINGS.""));
$type = $dsettings['term_type'];
$version = $dsettings['term_version'];
$display = $dsettings['term_listdisplay'];

if (file_exists(INFUSIONS."terms/".$type."locale/".$settings['locale'].".php")) {
	include INFUSIONS."terms/".$type."locale/".$settings['locale'].".php";
} else { include INFUSIONS."terms/".$type."locale/English.php"; }

if (isset($_POST['rowstart']) || isset($_GET['rowstart'])) {
	$rowstart = (isset($_GET['rowstart']) ? $_GET['rowstart'] : $_POST['rowstart']);
} else { $rowstart = ""; }

if (isset($_POST['items_per_page']) || isset($_GET['items_per_page'])) {
	$items_per_page = (isset($_GET['items_per_page']) ? $_GET['items_per_page'] : $_POST['items_per_page']);
} else { $items_per_page = "20"; }

if (isset($_POST['op']) || isset($_GET['op'])) {
	$op = (isset($_GET['op']) ? $_GET['op'] : $_POST['op']);
} else { $op = ""; }

if (isset($_POST['sortby']) || isset($_GET['sortby'])) {
	$sortby = (isset($_GET['sortby']) ? $_GET['sortby'] : $_POST['sortby']);
} else { $sortby = ""; }

if (isset($_POST['show_syn']) || isset($_GET['show_syn'])) {
	$show_syn = (isset($_GET['show_syn']) ? $_GET['show_syn'] : $_POST['show_syn']);
} else { $show_syn = ""; }

if (isset($_POST['cat_id']) || isset($_GET['cat_id'])) {
	$cat_id = (isset($_GET['cat_id']) ? $_GET['cat_id'] : $_POST['cat_id']);
} else { $cat_id = ""; }

if (isset($_POST['term_cat_id']) || isset($_GET['term_cat_id'])) {
	$term_cat_id = (isset($_GET['term_cat_id']) ? $_GET['term_cat_id'] : $_POST['term_cat_id']);
} else { $term_cat_id = ""; }

if (isset($_POST['term']) || isset($_GET['term'])) {
	$term = (isset($_GET['term']) ? $_GET['term'] : $_POST['term']);
} else { $term = ""; }

if (isset($_POST['id']) || isset($_GET['id'])) {
	$id = (isset($_GET['id']) ? $_GET['id'] : $_POST['id']);
} else { $id = ""; }

//include INFUSIONS."terms/include/functions.php";

$cresult = dbquery("SELECT * FROM ".DB_TERM_CATS." WHERE ".groupaccess('term_cat_access')."");
$rows = dbrows($cresult);
if ($rows != 0) {
	if (($op == "glos") && ($term != '')) {
		$term=preg_replace('/\%20/', ' ', $term);
		$resultg = dbquery("SELECT * FROM ".DB_TERMS." WHERE term_title='".$term."'");
		$grows = dbrows($resultg);
		$data = dbarray($resultg);
		if ($grows > 1) { // if term is included more than once, display links to all instances
			opentable($locale['term803']);
			echo "<table>";
			echo "<tr><td>".$locale['term801']."<br /><br /></td></tr>";
			echo "<tr><td>".$locale['term804'].": </td></tr>";
			$resultm = dbquery("SELECT t1.term_title term_title, t1.term_id term_id, t1.term_cat, t2.term_cat_name FROM ".DB_TERMS." t1 LEFT JOIN ".DB_TERM_CATS." t2 ON t2.term_cat_id=t1.term_cat WHERE term_title='".$term."'");
			while ($data = dbarray($resultm)) {
				echo "<tr><td><a href='".INFUSIONS."terms/terms.php?op=view&amp;id=".$data['term_id']."'>".$data['term_title']." (".$data['term_cat_name'].")</a></td></tr>";
			}
			echo "</table>";
			closetable();
		}
		elseif ($grows < 1) { // error message if term is not found
			opentable($locale['term803']);
			echo $locale['term802'];
			closetable();
		}
		else {
			if ($data['term_status'] == 1) { // if term is fixed synonym, redirect to 'parent term'
				$terms = $data['term_descript'];
				$results = dbquery("SELECT * FROM ".DB_TERMS." WHERE term_title='".$terms."'");
				$datas = dbarray($results);
				$term_id = $datas['term_id'];
				redirect(FUSION_SELF."?op=view&id=$term_id");
			}
			else {
				$term_id = $data['term_id']; // redirect to display term
				redirect(FUSION_SELF."?op=view&id=$term_id");
			}
		}
	}
	elseif (($op == "view") && ($id > 0)) { //display individual term
		require_once INCLUDES."comments_include.php";
		require_once INCLUDES."ratings_include.php";
		$result1 = dbquery("SELECT * FROM ".DB_TERMS." WHERE term_id='".$id."'");
		while ($data = dbarray($result1)) {
			$id = $data['term_id'];	
			opentable($locale['term301'].$data['term_title']);
			echo "<table border='0' cellpadding='0' cellspacing='1' width='100%'>\n";
			echo "<tr><td width='100%'>\n";
			echo "<table cellspacing='0' cellpadding='0' width='100%' border='0' class='tbl-border'>\n";
			echo "<tr><td width='100%'>\n";
			echo "<table width='100%' border='0' cellpadding='0' cellspacing='1'>\n";
			echo "<tr><td class='tbl2' nowrap><b>".$dsettings['term_org']."</b></td>\n";
			echo "<td class='tbl1' colspan='2' nowrap>".$data['term_title']."</td></tr>\n";
			echo "<tr><td class='tbl2' nowrap><b>".$dsettings['term_to']."</b></td>\n";
			echo "<td class='tbl1' colspan='2'>";
			if ($data['term_status'] == 1) {
				$terms = $data['term_descript'];
				$results = dbquery("SELECT * FROM ".DB_TERMS." WHERE term_title='".$terms."'");
				$datas = dbarray($results);
				echo $locale['term210']."<a href='".INFUSIONS."terms/terms.php?op=view&amp;id=".$datas['term_id']."' alt=''>".$datas['term_title']."</a>!";
			}
			else {
				echo nl2br(parseubb($data['term_descript']));
			}
			echo "</td></tr>\n";
			echo "<tr><td class='tbl2' nowrap><b>".$locale['term207']."</b></td>\n";
			echo "<td class='tbl1' colspan='2' nowrap>".retcatnameterm($data['term_cat'])."</td></tr>\n";
			if ($type == 0 AND $data['term_image'] != '') {
				echo "<tr><td class='tbl2' nowrap><b>".$locale['term212']."</b></td>\n";
				echo "<td class='tbl1' colspan='2' nowrap><img src='".$data['term_image']."' alt='' /></td>\n";
			}
			echo "<tr><td class='tbl2' nowrap><b>".$locale['term211']."</b></td>\n"; 
			echo "<td class='tbl1' colspan='2'>".$data['term_sender']."</td></tr>\n";
			if (checkrights("TER")) {
				echo "<tr><td class='tbl2' width='20%' nowrap><b>".$locale['term202']."</b></td>\n";
				echo "<td class='tbl1' width='70%' nowrap>".showdate("%d.%m.%y", $data['term_datestamp'])."</td>\n";
				echo "<td class='tbl1' width='10%' align='right'><a href='".INFUSIONS."terms/terms_admin.php?step=edit&amp;term_cat_id=".$data['term_cat']."&amp;term_id=".$id."'>".$locale['term504']."</a> <a href='".INFUSIONS."terms/terms_admin.php?step=edit&amp;term_cat_id=".$data['term_cat']."&amp;term_id=".$id."'><img src=".INFUSIONS."terms/images/edit.gif border='0' title='".$locale['term504']."' alt='".$locale['term504']."' /></a></td>\n";
			}
			else {
				echo "<tr><td class='tbl2' width='20%' nowrap><b>".$locale['term202']."</b></td>\n";
				echo "<td class='tbl1' colspan='2' nowrap>".showdate("%d.%m.%y", $data['term_datestamp'])."</td>\n";
			}
			if ($dsettings['term_ratings'] == 1) {
				echo "<tr><td class='tbl2' width='12%' nowrap><b>".$locale['term206']."</b></td>\n";
				echo "<td class='tbl1' valign='top' align='left' colspan='3'>".calc_rating($id)."</td></tr>\n";
			}
			echo "</table>\n";		
			echo "</td></tr></table>\n";
			echo "</td></tr>\n";
			echo "<tr><td class='tbl1' align='center'><input type='button' value='".$locale['term305']."' onClick='history.back()' />";
			echo "</td></tr>\n";
			echo "</table>\n";
		}
		closetable();
		showcomments("D","terms","term_id",$id,"terms.php?op=view&amp;id=$id");
		if ($dsettings['term_ratings'] == 1) {
			showratings("D",$id,FUSION_SELF."?op=view&amp;id=$id");
		}
		if (iMEMBER AND !checkrights("TER")) {
			echo "<div style='margin:5px'></div>\n";
			opentable($locale['term701']);
			echo "<table><tr><td align='center'>".$locale['term702']."</td></tr>\n";
			echo "<tr><td align='center'><a href='terms_admin.php' title='".$locale['term701']."'><b>".$locale['term701']."</b></a></td></tr>\n";
			echo "</table>"; 
			closetable();
		}
	}
	else {
		opentable($locale['term101']." - v".$version);	// start of page displaying list of terms
		echo "<form name='viewsettings' method='post' action='".FUSION_SELF."?rowstart=".$rowstart."'>\n";
		echo "<table width='100%' align='center' cellspacing='0' cellpadding='0' border='0'>\n";
		echo "<tr><td align='right' width='50%' class='tbl'>".$locale['term451']."</td>\n";
		echo "<td class='tbl' align='left'>";
		echo "<select name='cat_id' class='textbox' onChange='submit()'>\n";
		echo "<option value=''>".$locale['term452']."</option>\n";
		$rescat = dbquery("SELECT * FROM ".DB_TERM_CATS." WHERE ".groupaccess('term_cat_access')." ORDER BY term_cat_name ASC");
		while ($data = dbarray($rescat)) {
			if ( $cat_id == $data["term_cat_id"]) {
				echo "<option value='".$data["term_cat_id"]."' selected>".$data["term_cat_name"]."</option>\n";
			}
			else {
				echo "<option value='".$data["term_cat_id"]."'>".$data["term_cat_name"]."</option>\n";
			}
		}
		echo "</select></td></tr>\n";
		echo "<tr><td class='tbl' align='right'>".$locale['term456']."</td>";
		echo "<td class='tbl' align='left'>";
		echo "<select name='show_syn' class='textbox' onChange='submit()'>\n";
		echo "<option value='0'".($show_syn == "0" ? " selected" : "").">".$locale['term454']."</option>\n"; //No
		echo "<option value='1'".($show_syn == "1" ? " selected" : "").">".$locale['term455']."</option>\n"; //Yes
		if (checkrights("TER")) {
			echo "<option value='2'".($show_syn == "2" ? " selected" : "").">".$locale['term460']."</option>\n"; //Submitted
		}
		echo "</select></td></tr>\n";
		echo "<tr><td class='tbl' align='right'>".$locale['term458'].": </td>";
		echo "<td class='tbl' align='left'>";
		echo "<select name='items_per_page' class='textbox' onChange='submit()'>\n";
		echo "<option value='5'".($items_per_page == "5" ? " selected" : "").">5</option>\n";
		echo "<option value='10'".($items_per_page == "10" ? " selected" : "").">10</option>\n";
		echo "<option value='20'".($items_per_page == "20" ? " selected" : "").">20</option>\n";
		echo "<option value='50'".($items_per_page == "50" ? " selected" : "").">50</option>\n";
		echo "</select></td></tr>\n";
//0=approved
//1=synonym (fixed)
//3=synonym (free)
//2=submitted
		if (checkrights("TER")) {
			echo "<tr><td class='tbl' align='center' colspan='2'><a href='".INFUSIONS."terms/terms_admin.php'>".$locale['term459']."</a></td></tr>";
		}
		echo "</table></form>\n";  //end of standard header page displaying list of terms

		$orderby = ($sortby == "all" ? "" : " AND tt.term_title LIKE '".stripinput($sortby)."%'");
		if ($show_syn == 0) {
			$and = " AND tt.term_status = \"0\"";
		}
		elseif ($show_syn == 2) {
			$and = " AND (tt.term_status = \"2\" OR tt.term_cat = \"1\")";
		}
		else {
			$and = " AND tt.term_status != \"2\"";
		}
		if ($cat_id > 0) {
			$where = " tt WHERE tt.term_cat='".$cat_id."'";
		}
		else {
			$where = " tt LEFT JOIN ".DB_TERM_CATS." tc ON tc.term_cat_id=tt.term_cat WHERE ".groupaccess('term_cat_access')."";
		}
		if ($cat_id > 0) {
			$where3 = " WHERE term_cat_id='".$cat_id."'";
		}
		else {
			$where3 = " WHERE ".groupaccess('term_cat_access')."";
		}
		$order = " term_title ASC";
		$rows  = dbrows(dbquery("SELECT tt.*,term_cat FROM ".DB_TERMS.$where.$and.$orderby));
		if (!isset($rowstart) || !isnum($rowstart)) { $rowstart = 0; } else { $rowstart = $rowstart; }
		echo "<table width='100%' align='center' cellspacing='0' cellpadding='0' border='0'>\n"; // table displaying list of terms
		$catname = "";
		if ($show_syn == 0) {
			$and2 = " AND term_status = \"0\"";
		}
		elseif ($show_syn == 2) {
			$and2 = " AND (term_status = \"2\" OR term_cat = \"1\")";
		}
		else {
			$and2 = " AND term_status != \"2\"";
		}
		if ($cat_id > 0) {
			$where2 = " AND term_cat ='".$cat_id."'";
		}
		else {
			$where2 = "";
		}
		$result1 = dbquery("SELECT tu.*, tn.*, term_cat_id, term_cat_name FROM ".DB_TERM_CATS." tn LEFT JOIN ".DB_TERMS." tu ON tn.term_cat_id=tu.term_cat WHERE ".groupaccess('term_cat_access')." AND term_id!=''".$where2.$and2." ORDER BY term_cat_name ASC,".$order." LIMIT $rowstart, $items_per_page");
		if (dbrows($result1) != 0) {
			if (dbrows($result1) > 0) {
				$rows1 = dbrows($result1);
				if ($display  == 0) { // select list display type
					$orderby = ($sortby == "all" ? "" : " AND term_title LIKE '".stripinput($sortby)."%'");
					if ($show_syn == 0) {
						$and2 = " AND term_status = \"0\"";
					}
					elseif ($show_syn == 2) {
						$and2 = " AND (term_status = \"2\" OR term_cat = \"1\")";
					}
					else {
						$and2 = " AND term_status != \"2\"";
					}
					if ($cat_id > 0) {
						$where2 = " AND term_cat ='".$cat_id."'";
					}
					else {
						$where2 = "";
					}
					$result2 = dbquery("SELECT tu.*, tn.*, term_cat_id, term_cat_name FROM ".DB_TERM_CATS." tn LEFT JOIN ".DB_TERMS." tu ON tn.term_cat_id=tu.term_cat WHERE ".groupaccess('term_cat_access')." AND term_id!=''".$and2.$orderby.$where2." ORDER BY tu.term_title ASC,".$order." LIMIT $rowstart,$items_per_page");
					echo "<tr><td><table width='100%' align='center' border='0' cellpadding='0' cellspacing='1'>\n<tr><td>\n";
					$search = array(
						"0","1","2","3","4","5","6","7","8","9","A","B","C","D","E","F","G","H",
						"I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"
					);
					echo "<hr />\n<table width='100%'><tr><td><table align='center' cellpadding='0' cellspacing='1' class='tbl-border'>\n<tr>\n";
					$and3 = "&amp;items_per_page=".$items_per_page."&amp;show_syn=".$show_syn."&amp;cat_id=".$cat_id."";
					echo "<td rowspan='2' class='tbl2'><a href='".FUSION_SELF."?sortby=all".$and3."'>".$locale['term471']."</a></td>";
					for ($i=0;$i < 36!="";$i++) {
						echo "<td align='center' class='tbl1'><div class='small'><a href='".FUSION_SELF."?sortby=".$search[$i].$and3."'>".$search[$i]."</a></div>";
						echo ($i==17 ? "<td rowspan='2' class='tbl2'><a href='".FUSION_SELF."?sortby=all".$and3."'>".$locale['term471']."</a></td>\n</tr>\n<tr>\n" : "\n");
					}
					echo "</td></tr></table>\n<hr />";
					if (dbrows($result2) < 1) {
						echo "<table width='100%'><tr><td align='center'>".$locale['term472'].$sortby."</td></tr></table>\n";
					}

					$initial = $initial2 = "";
					while ($data3 = dbarray($result2)) {
						$initial = substr(($data3['term_title']),0,1);
						$initial = strtoupper($initial);
						$description = stripslashes($data3['term_descript']);
						$description = nl2br(parseubb($description));
						if ($initial2 != $initial) {
							$initial2 = $initial;
							echo "<tr><td class='tbl1' valign='bottom'><br /><font size='+1'><b>".$initial2."</b></font></td></tr>\n";
						}
						echo "<tr><td class='tbl1'><b><a href='".FUSION_SELF."?op=view&amp;id=".$data3['term_id']."'>".$data3['term_title']."</a></b></td></tr>\n";
						echo "<tr><td class='tbl2'>".$description."";
						if ($data3['term_status'] == '1') {
							echo " (".$locale['term457'].")";
						}
						if ($type == 0 AND $data3['term_image'] != '') {
							echo "<tr><td class='tbl1'><img src='".$data3['term_image']."' alt='' />\n";
						}
					}
//					echo "</td></tr>\n";}
					echo "</td></tr></table>\n";
				}
				else { // second display typ
					echo "<tr class='tbl2'><td><table width='100%' align='center' border='0' cellpadding='0' cellspacing='1'>\n";
					echo "<tr><td class='tbl2' align='left' width='25%' colspan='2'><b>".$locale['term204']."</b></td>\n";
					echo "<td class='tbl2' align='left' width='45%'><b>".$locale['term201']."</b></td>\n";
					echo "<td class='tbl2' align='center' nowrap width='10%'><b>".$locale['term203']."</b></td>\n";
					echo "<td class='tbl2' align='center' nowrap width='10%'><b>".$locale['term202']."</b></td>\n";
					if ($dsettings['term_ratings'] == 1) {
						echo "<td class='tbl2' valign='center' align='left' nowrap width='10%'><b>".$locale['term206']."</b></td>\n"; 
					}
					echo "</tr>\n";
				while ($data = dbarray($result1)) {
					if ( ($catname == "") || ($catname != $data['term_cat_name']) ) {
						$catname = $data['term_cat_name'];
						if ($dsettings['term_ratings'] == 1) {
							echo "<tr><td class='forum-caption' colspan='6'>".$catname."</td></tr>\n";
						}
						else {
							echo "<tr><td class='forum-caption' colspan='5'>".$catname."</td></tr>\n";
						}
					}
//					}
					if ($data['term_datestamp']+604800 > time()+($settings['timeoffset']*3600)) {
						$new = "<img src='".INFUSIONS."terms/images/new.gif' alt='' border='0' />";
					} 
					else {
						$new = "<img src='".THEME."images/blank.gif' width='20' height='1' border='0' alt='' />";
					}
					$description = stripslashes($data['term_descript']);
//					$description = trimlink(stripubb($description), 60);
					$description = trimlink(stripubbterm($description), 60);
					echo "<tr><td width='30' class='tbl1' valign='middle' align='left'>".$new."</td>\n";
					if ($data['term_status'] == 1) {
						$datas1 = dbarray(dbquery("SELECT * FROM ".DB_TERMS." WHERE term_title='".$description."'"));
						echo "<td class='tbl1' valign='top' align='left'><a title='".$locale['term301'].$data['term_title']."' href='".FUSION_SELF."?op=view&amp;id=".$data['term_id']."'>".$data['term_title']."</a></td>\n";
						echo "<td class='tbl1' valign='top' align='left'>".$locale['term209']."<a href='".INFUSIONS."terms/terms.php?op=view&amp;id=".$datas1['term_id']."'>".$description."</a></td>\n";
					}
					else {
						echo "<td class='tbl1' valign='top' align='left'><a title='".$locale['term301'].$data['term_title']."' href='".FUSION_SELF."?op=view&amp;id=".$data['term_id']."'>".$data['term_title']."</a></td>\n";
						echo "<td class='tbl1' valign='top' align='left'>".$description."</td>\n"; }
						echo "<td class='tbl1' valign='top' align='center'>".$data['term_sender']."</td>\n";
						echo "<td class='tbl1' valign='top' align='center' nowrap>".showdate("%d/%m/%Y", $data['term_datestamp'])."</td>\n";
						if ($dsettings['term_ratings'] == 1) {
							echo "<td class='tbl1' valign='top' align='right'>".calc_rating($data['term_id'])."</td>\n"; 
						}
						echo "</tr>\n";
					}
				}
			}
		}
		else {
			echo "<td><table width='100%'><tr><td class='tbl1' valign='top' align='center' colspan='6'>".$locale['term528']."</td>\n";
			echo "</tr>\n";
		}
		echo "</table>\n";
		echo "</td></tr></table>\n";
		if ($rows > $items_per_page) {
			echo "<div align='center' style='margin-top:5px;'>".makePageNav1($rowstart,$items_per_page,$rows,1,FUSION_SELF."?",$show_syn, $cat_id, $sortby)."\n</div>\n";
		}
		closetable(); 

		if (iMEMBER AND !checkrights("TER")) {
			echo "<div style='margin:5px'></div>\n";
			opentable($locale['term701']);
			echo "<table><tr><td align='center'>".$locale['term702']."</td></tr>\n";
			echo "<tr><td align='center'><a href='terms_admin.php' title='".$locale['term701']."'><b>".$locale['term701']."</b></a>";
			echo "</td></tr></table>";
			closetable();
		}
	}
}
	
else {
	opentable($locale['term101']." - v".$version);	
	echo "<div align='center' style='margin-top:5px;'><b>".$locale['term453']."</b></div>\n";
	closetable();
}

require_once THEMES."templates/footer.php";

function calc_rating ($id) {
	global $locale;

	$num_votes = dbresult(dbquery("SELECT COUNT(rating_item_id) FROM ".DB_RATINGS." WHERE rating_item_id='".$id."' AND rating_type='D'"),0);
	$tot_votes = dbresult(dbquery("SELECT SUM(rating_vote) FROM ".DB_RATINGS." WHERE rating_item_id='".$id."' AND rating_type='D'"),0);
	if (( $num_votes > 0 ) && ($tot_votes > 0)) {
		$pct_rating = ceil(round($tot_votes / $num_votes));
		$vote = "<img src='".INFUSIONS."terms/images/cube_".$pct_rating.".gif' border='0' alt='' />";
	}
	else {
		$vote = "0 ".$locale['term208'];
	}
	return $vote;
}

// Specifically modified from universal page pagination function by CrappoMan
function makepagenav1($start, $count, $total, $range = 4, $link = "", $show_syn, $cat_id, $sortby) {
	global $locale;
	if ($link == "") { $link = FUSION_SELF."?"; }
	$res = "";
	$pg_cnt = ceil($total / $count);
	if ($pg_cnt > 1) {
		$idx_back = $start - $count;
		$idx_next = $start + $count;
		$cur_page = ceil(($start + 1) / $count);
		$res .= "\n<table cellspacing='1' cellpadding='1' border='0' class='tbl-border'>\n<tr>\n";
		$res .= "<td class='tbl2'><span class='small'>".$locale['global_092']."$cur_page".$locale['global_093']."$pg_cnt</span></td>\n";
		if ($idx_back >= 0) {
			if ($cur_page > ($range + 1)) {
				$res .= "<td class='tbl2'><a href='".$link."rowstart=0' class='small'>&lt;&lt;</a></td>\n";
			}
			$res .= "<td class='tbl2'><a href='".$link."rowstart=".$idx_back."' class='small'>&lt;</a></td>\n";
		}
		$idx_fst = max($cur_page - $range, 1);
		$idx_lst = min($cur_page + $range, $pg_cnt);
		if ($range == 0) {
			$idx_fst = 1;
			$idx_lst = $pg_cnt;
		}
		for ($i = $idx_fst; $i <= $idx_lst; $i++) {
			$offset_page = ($i - 1) * $count;
			if ($i == $cur_page) {
				$res .= "<td class='tbl1'><span class='small'><strong>".$i."</strong></span></td>\n";
			}
			else {
				$res .= "<td class='tbl1'><a href='".$link."rowstart=".$offset_page."&amp;items_per_page=".$count."&amp;show_syn=".$show_syn."&amp;cat_id=".$cat_id."&amp;sortby=".$sortby."' class='small'>".$i."</a></td>\n";
			}
		}
		if ($idx_next < $total) {
			$res .= "<td class='tbl2'><a href='".$link."rowstart=".$idx_next."&amp;items_per_page=".$count."&amp;show_syn=".$show_syn."&amp;cat_id=".$cat_id."&amp;sortby=".$sortby."' class='small'>&gt;</a></td>\n";
			if ($cur_page < ($pg_cnt - $range)) {
				$res .= "<td class='tbl2'><a href='".$link."rowstart=".($pg_cnt - 1) * $count."&amp;items_per_page=".$count."&amp;show_syn=".$show_syn."&amp;cat_id=".$cat_id."&amp;sortby=".$sortby."' class='small'>&gt;&gt;</a></td>\n";
			}
		}
		$res .= "</tr>\n</table>\n";
	}
	return $res;
}
?>