<?php
/*-------------------------------------------------------+
| PHP-Fusion 6 Content Management System
| Copyright  2002 - 2008 Nick Jones
| http://www.php-fusion.co.uk/
+--------------------------------------------------------+
| Filename: infusion.php
| Forum - Limiter of Number of Threads
| author: Paul Beuk  2007-2008
| http://www.muscapaul.com/
| email: muscapaul@gmail.com
+--------------------------------------------------------+
| This program is released as free software under the
| Affero GPL license. You can redistribute it and/or
| modify it under the terms of this license which you
| can read by viewing the included agpl.txt or online
| at www.gnu.org/licenses/agpl.html. Removal of this
| copyright header is strictly prohibited without
| written permission from the original author(s).
+--------------------------------------------------------*/
if (!defined("IN_FUSION")) { die("Access Denied"); }

include INFUSIONS."forum_limit/infusion_db.php";

if (file_exists(INFUSIONS."forum_limit/locale/".$settings['locale'].".php")) {
	include INFUSIONS."forum_limit/locale/".$settings['locale'].".php";
} else {
	include INFUSIONS."forum_limit/locale/English.php";
}

// Infusion general information
$inf_title = $locale['FLIM101'];
$inf_description = $locale['FLIM102'];
$inf_version = "1.00";
$inf_developer = "muscapaul";
$inf_email = "muscapaul@gmail.com";
$inf_weburl = "http://www.muscapaul.com";

$inf_folder = "forum_limit"; // The folder in which the infusion resides.

// Delete any items not required here.
$inf_newtable[1] = DB_FORUM_THREAD_CREATION." (
	thread_id smallint(5) unsigned NOT NULL auto_increment,
	forum_no smallint(5) NOT NULL default '0',
	thread_no smallint(5) NOT NULL default '0',
	creation_datestamp int(10) unsigned NOT NULL default '0',
	thread_author smallint(5) unsigned NOT NULL default '0',
	PRIMARY KEY  (thread_id)
) TYPE=MyISAM;";

$inf_newtable[2] = DB_FORUM_LIMIT_SETTINGS." (
	settings_id smallint(3) unsigned NOT NULL auto_increment,
	forum_no smallint(5) NOT NULL default '0',
	max_threads smallint(5) NOT NULL default '0',
	limit_period smallint(5) NOT NULL default '0',
	max_per_user smallint(5) NOT NULL default '0',
	user_period smallint(5) NOT NULL default '0',
	PRIMARY KEY  (settings_id)
) TYPE=MyISAM;";

$inf_newtable[3] = DB_FORUM_GLOBAL_LIMIT_SETTINGS." (
	global_setting tinyint(1) NOT NULL default '0',
	global_max_posts smallint(5) NOT NULL default '0',
	global_limit_period smallint(5) NOT NULL default '0',
	PRIMARY KEY  (global_setting)
) TYPE=MyISAM;";

$inf_insertdbrow[1] = DB_FORUM_GLOBAL_LIMIT_SETTINGS." (global_setting, global_max_posts, global_limit_period) VALUES ('0', '0', '0')";

$inf_droptable[1] = DB_FORUM_THREAD_CREATION;
$inf_droptable[2] = DB_FORUM_LIMIT_SETTINGS;
$inf_droptable[3] = DB_FORUM_GLOBAL_LIMIT_SETTINGS;

$inf_adminpanel[1] = array(
	"title" => $locale['FLIM101'],
	"image" => "infusion_panel.gif",
	"panel" => "forum_limit_settings.php",
	"rights" => "FLIM"
);
?>
