<?php
/*-------------------------------------------------------+
| PHP-Fusion 7 Content Management System
| Copyright (c) 2002-2008 Nick Jones
| http://www.php-fusion.co.uk/
+--------------------------------------------------------+
| Forum - Limiter of Number of Threads
| author: Paul Beuk  2007-2008
| http://www.muscapaul.com/
| email: muscapaul@gmail.com
+--------------------------------------------------------+
| This program is released as free software under the
| Affero GPL license. You can redistribute it and/or
| modify it under the terms of this license which you
| can read by viewing the included agpl.txt or online
| at www.gnu.org/licenses/agpl.html. Removal of this
| copyright header is strictly prohibited without
| written permission from the original author(s).
+--------------------------------------------------------*/

require_once "../../maincore.php";
require_once THEMES."templates/admin_header.php";

if (!checkrights("FLIM") || !defined("iAUTH") || $_GET['aid'] != iAUTH) { redirect("../index.php"); }

include INFUSIONS."forum_limit/infusion_db.php";

if (file_exists(INFUSIONS."forum_limit/locale/".$settings['locale'].".php")) {
	include INFUSIONS."forum_limit/locale/".$settings['locale'].".php";
} else { include INFUSIONS."forum_limit/locale/English.php"; }

$step = isset($_REQUEST['step']) ? $_REQUEST['step'] : "";
$forum_no = (isset($_REQUEST['forum_no']) AND isnum($_REQUEST['forum_no'])) ? $_REQUEST['forum_no'] : "";
$max_threads = (isset($_REQUEST['max_threads']) AND isnum($_REQUEST['max_threads'])) ? $_REQUEST['max_threads'] : "";
$limit_period = (isset($_REQUEST['limit_period']) AND isnum($_REQUEST['limit_period'])) ? $_REQUEST['limit_period'] : "";
$global_limit_period = (isset($_REQUEST['global_limit_period']) AND isnum($_REQUEST['global_limit_period'])) ? $_REQUEST['global_limit_period'] : "";
$max_per_user = (isset($_REQUEST['max_per_user']) AND isnum($_REQUEST['max_per_user'])) ? $_REQUEST['max_per_user'] : "";
$global_setting = (isset($_REQUEST['global_setting']) AND isnum($_REQUEST['global_setting'])) ? $_REQUEST['global_setting'] : "";
$global_max_posts = (isset($_REQUEST['global_max_posts']) AND isnum($_REQUEST['global_max_posts'])) ? $_REQUEST['global_max_posts'] : "";
$user_period = (isset($_REQUEST['user_period']) AND isnum($_REQUEST['user_period'])) ? $_REQUEST['user_period'] : "";
$settings_id = (isset($_REQUEST['settings_id']) AND isnum($_REQUEST['settings_id'])) ? $_REQUEST['settings_id'] : "";
$saveforumsetting = isset($_REQUEST['saveforumsetting']) ? $_REQUEST['saveforumsetting'] : "";
$saveglforumsetting = isset($_REQUEST['saveglforumsetting']) ? $_REQUEST['saveglforumsetting'] : "";

if (iADMIN AND $step=='delete') {
	$result = dbquery("DELETE FROM ".DB_FORUM_LIMIT_SETTINGS." WHERE settings_id='$settings_id'");
	redirect(FUSION_SELF.$aidlink);
}

if ($saveforumsetting != '') {
	$error = '';
	if (!isnum($forum_no)) { $error = $locale['FLIM302']; }
	if (!isnum($max_threads)) { $error = $locale['FLIM303']; }
	if (!isnum($limit_period)) { $error = $locale['FLIM304']; }
	if (!isnum($max_per_user)) { $error = $locale['FLIM303']; }
	if (!isnum($user_period)) { $error = $locale['FLIM304']; }

	if ($error != '') {
		opentable($locale['FLIM301']);
		echo $error;
		closetable();
	}
	else {
		if ($max_per_user == '0' || ($max_per_user > $max_threads && $max_threads != '0')) { $max_per_user=$max_threads; }
		if ($user_period == '0') { $user_period = $limit_period; }
		$checkforum = dbquery("SELECT * FROM ".DB_FORUM_LIMIT_SETTINGS." WHERE forum_no='$forum_no'");
		if (dbrows($checkforum) != '') {
			$result = dbquery("UPDATE ".DB_FORUM_LIMIT_SETTINGS." SET forum_no='$forum_no', max_threads='$max_threads', limit_period='$limit_period', max_per_user='$max_per_user', user_period='$user_period' WHERE forum_no='$forum_no'");
			redirect(FUSION_SELF.$aidlink);
		}
		else {
			if ($settings_id != '') {
				$result = dbquery("UPDATE ".DB_FORUM_LIMIT_SETTINGS." SET forum_no='$forum_no', max_threads='$max_threads', limit_period='$limit_period', max_per_user='$max_per_user', user_period='$user_period' WHERE settings_id='$settings_id'");
				redirect(FUSION_SELF.$aidlink);
			}
			else {
				$result = dbquery("INSERT INTO ".DB_FORUM_LIMIT_SETTINGS." VALUES('', '$forum_no', '$max_threads', '$limit_period', '$max_per_user', '$user_period')");
				redirect(FUSION_SELF.$aidlink);
			}
		}
	}
}

if ($saveglforumsetting != '') {
	$error = '';
	if (!isnum($global_limit_period)) { $error = $locale['FLIM304']; }
	if (!isnum($global_max_posts)) { $error = $locale['FLIM305']; }
	if ($global_setting != '0' && ($global_max_posts == '0' || $global_limit_period == '0')) { $error = $locale['FLIM306']; }

	if ($error!='') {
		opentable($locale['FLIM301']);
		echo $error;
		closetable();
		tablebreak();
	}
	else {
		if ($global_setting == '0') {
			$global_max_posts = '0';
			$global_limit_period = '0';
		}
		$result = dbquery("UPDATE ".DB_FORUM_GLOBAL_LIMIT_SETTINGS." SET global_setting='$global_setting', global_max_posts='$global_max_posts', global_limit_period='$global_limit_period'");
		redirect(FUSION_SELF.$aidlink);
	}
}


if ((iADMIN) AND $step == "edit") {
	$result = dbquery("SELECT * FROM ".DB_FORUM_LIMIT_SETTINGS." WHERE settings_id='$settings_id'");
	$data = dbarray($result);
	$forum_no = $data['forum_no'];
	$max_threads = $data['max_threads'];
	$limit_period = $data['limit_period'];
	$max_per_user = $data['max_per_user'];
	$user_period = $data['user_period'];
	$formaction = FUSION_SELF.$aidlink."&amp;step=edit&amp;settings_id=".$settings_id."";
	opentable($locale['FLIM101']." - ".$locale['FLIM203']);
}
else {
	$global_data = dbarray(dbquery("SELECT * FROM ".DB_FORUM_GLOBAL_LIMIT_SETTINGS.""));
	$forum_no = '';
	$max_threads = '';
	$limit_period = '';
	$max_per_user = '';
	$user_period = '';
	$formaction = FUSION_SELF.$aidlink."&amp;step=edit&settings_id=";

	opentable($locale['FLIM101']." - ".$locale['FLIM228']);
	echo "<form name='glsettingsform' method='post' action='".$formaction."'>";
	echo "<table align='center' cellpadding='0' cellspacing='0' border='0' width='100%'>";
	echo "<tr><td colspan='2' align='center' class='tbl'><b>".$locale['FLIM220']."</b></td></tr>\n";
	echo "<tr><td align='right' class='tbl' width='40%'>".$locale['FLIM221'].": </td><td align='left' class='tbl'>";
	echo "<select name='global_setting' class='textbox'>\n";
	echo "<option value='0'".($global_data['global_setting'] == "0" ? " selected" : "").">".$locale['FLIM222']."</option>\n";
	echo "<option value='1'".($global_data['global_setting'] == "1" ? " selected" : "").">".$locale['FLIM223']."</option>\n";
	echo "<option value='2'".($global_data['global_setting'] == "2" ? " selected" : "").">".$locale['FLIM224']."</option>\n";
	echo "</select>";
	echo "</td></tr>";
	echo "<tr><td align='right' class='tbl'>".$locale['FLIM225'].": </td>";
	echo "<td class='tbl'><input type='text' name='global_max_posts' value='".$global_data['global_max_posts']."' maxlength='5' class='textbox' style='width:40px;' /></td></tr>";
	echo "<tr><td align='right' class='tbl'>".$locale['FLIM219'].":</td>";
	echo "<td class='tbl'><input type='text' name='global_limit_period' value='".$global_data['global_limit_period']."' maxlength='5' class='textbox' style='width:40px;' /></td></tr>";

	echo "<tr><td align='center' colspan='2' class='tbl'><input type='submit' name='saveglforumsetting' value='".$locale['FLIM208']."' class='button' /></td></tr>";
	echo "</table></form>\n";
	closetable();
	tablebreak();

	opentable($locale['FLIM101']." - ".$locale['FLIM204']);
}

echo "<form name='settingsform' method='post' action='".$formaction."'>";
echo "<table align='center' cellpadding='0' cellspacing='0' width='100%'>";
echo "<tr><td colspan='2' align='center'><b>".$locale['FLIM226']."</b></td></tr>\n";
echo "<tr><td colspan='2'><input type='hidden' name='settings_id' value='".$settings_id."' /></td></tr>\n";
$editlist = $sel = ""; 
$result2 = dbquery("SELECT * FROM ".DB_FORUMS." ORDER BY forum_name");
if (dbrows($result2) != 0) {
	while ($data2 = dbarray($result2)) {
		if ($step == "edit") { $sel = ($data['forum_no'] == $data2['forum_id'] ? " selected" : ""); }
		$editlist .= "<option value='".$data2['forum_id']."'$sel>".$data2['forum_name']."</option>\n";
	}
}
echo "<tr><td align='right' class='tbl' width='40%'>".$locale['FLIM205'].":</td>";
echo "<td class='tbl1'><select name='forum_no' class='textbox' style='width:380px;'>".$editlist."</select></td></tr>\n"; 
echo "<tr><td align='right' class='tbl'>".$locale['FLIM206'].":</td>";
echo "<td class='tbl'><input type='text' name='max_threads' value='".$data['max_threads']."' maxlength='5' class='textbox' style='width:40px;' /></td></tr>";
echo "<tr><td align='right' class='tbl'>".$locale['FLIM207'].":</td>";
echo "<td class='tbl'><input type='text' name='limit_period' value='".$data['limit_period']."' maxlength='5' class='textbox' style='width:40px;' /></td></tr>";
echo "<tr><td align='right' class='tbl'>".$locale['FLIM218'].":</td>";
echo "<td class='tbl'><input type='text' name='max_per_user' value='".$data['max_per_user']."' maxlength='5' class='textbox' style='width:40px;' /></td></tr>";
echo "<tr><td align='right' class='tbl'>".$locale['FLIM219'].":</td>";
echo "<td class='tbl'><input type='text' name='user_period' value='".$data['user_period']."' maxlength='5' class='textbox' style='width:40px;' /></td></tr>";
echo "<tr><td align='center' colspan='2' class='tbl'><input type='submit' name='saveforumsetting' value='".$locale['FLIM208']."' class='button' /></td></tr>";
echo "</table></form>\n";
closetable();
tablebreak();
opentable($locale['FLIM202']);
echo "<table align='center' cellpadding='0' cellspacing='0' border='0' width='100%'>";
$present = dbquery("SELECT t1.*, t2.* FROM ".DB_FORUM_LIMIT_SETTINGS." t1 LEFT JOIN ".DB_FORUMS." t2 ON t1.forum_no=t2.forum_id WHERE t1.settings_id!='' ORDER BY t2.forum_name ASC");
$set_forum_no = dbrows($present);
if ($set_forum_no == '0') {
	echo "<tr><td class='tbl1' colpan='6'>".$locale['FLIM227']."</td></tr>";
}
else {
	echo "<tr><td class='tbl1'>".$locale['FLIM212']."</td>\n";
	echo "<td class='tbl1' align='right'>".$locale['FLIM213']."</td>\n";
	echo "<td class='tbl1' align='left'>".$locale['FLIM214']."</td>\n";
	echo "<td class='tbl1' align='right'>".$locale['FLIM215']."</td>\n";
	echo "<td class='tbl1' align='left'>".$locale['FLIM216']."</td>\n";
	echo "<td class='tbl1' colspan='2' align='center'>".$locale['FLIM217']."</td></tr>\n";
	while ($presentdata = dbarray($present)) {
		if ($presentdata['forum_name']!='') {
			echo "<tr><td class='tbl1'>".$presentdata['forum_name']."</td>";
		}
		else {
			echo "<tr><td class='tbl1'>".$locale['FLIM211']."</td>";
		}
		echo "<td class='tbl1' align='center'>".$presentdata['max_threads']."</td>";
		echo "<td class='tbl1' align='center'>".$presentdata['limit_period']."</td>";
		echo "<td class='tbl1' align='center'>".$presentdata['max_per_user']."</td>";
		echo "<td class='tbl1' align='center'>".$presentdata['user_period']."</td>";
		echo "<td class='tbl1' align='center'><a href='".FUSION_SELF.$aidlink."&amp;step=edit&settings_id=".$presentdata['settings_id']."' alt='".$locale['FLIM209']."'>".$locale['FLIM209']."<a></td></td>";
		echo "<td class='tbl1' align='center'><a href='".FUSION_SELF.$aidlink."&amp;step=delete&settings_id=".$presentdata['settings_id']."' alt='".$locale['FLIM210']."'>".$locale['FLIM210']."<a></td></tr>";

	}
}
echo "</table>";
closetable();
require_once THEMES."templates/footer.php";
?>