<?php
/*---------------------------------------------------+
| PHP-Fusion 7 - Content Management System
+----------------------------------------------------+
| author: Nick Jones (Digitanium)  2002-2008
| web: http://www.php-fusion.co.uk
| email: nick@php-fusion.co.uk
+----------------------------------------------------+
| Updated for PHP-Fusion v7
| by muscapaul
| muscapaul@gmail.com / http://www.muscapaul.com
+----------------------------------------------------+
| This program is released as free software under the
| Affero GPL license. You can redistribute it and/or
| modify it under the terms of this license which you
| can read by viewing the included agpl.txt or online
| at www.gnu.org/licenses/agpl.html. Removal of this
| copyright header is strictly prohibited without
| written permission from the original author(s).
+----------------------------------------------------*/

if (!defined("IN_FUSION")) { die("Access Denied"); }

if (file_exists(INFUSIONS."error_reports/locale/".$settings['locale'].".php")) {
	include INFUSIONS."error_reports/locale/".$settings['locale'].".php";
} else {
	include INFUSIONS."error_reports/locale/English.php";
}

include INFUSIONS."error_reports/infusion_db.php";

$period = 3600 * 24 * 15;

$result = dbquery("SELECT * FROM ".DB_ERROR_REPORTS." WHERE (".time()."-error_datestamp < $period) ORDER BY error_datestamp DESC LIMIT 0,5");
if (dbrows($result) != 0) {
	openside($locale['err100']);
	echo "<table width='100%'>";
	while ($data = dbarray($result)) {
		$error_summary = trimlink($data['error_summary'], 23);
		$error_description = trimlink($data['error_description'], 60);
		echo "<tr><td>".THEME_BULLET." <a href='".INFUSIONS."error_reports/error_reports.php?step=view&amp;error_id=".$data['error_id']."' title='".$error_description."' class='side'>".$error_summary."</a></td>\n";
		if ($data['error_status'] == '0') {
			echo "<td>0</td></tr>";
		}
		if ($data['error_status'] == '1') {
			echo "<td>|</td></tr>";
		}
		if ($data['error_status'] == '2') {
			echo "<td>_</td></tr>";
		}
	}
	echo "</table>";
	closeside();
}
?>