<?php
/*---------------------------------------------------+
| PHP-Fusion 7 Content Management System
+----------------------------------------------------+
| Copyright  2002 - 2008 Nick Jones
| http://www.php-fusion.co.uk/
+----------------------------------------------------+
| Copyright  2008 muscapaul    
| Terms Infusion (Dictionary/Glossary)
| by muscapaul
| muscapaul@gmail.com / http://www.muscapaul.com
+----------------------------------------------------+
| This program is released as free software under the
| Affero GPL license. You can redistribute it and/or
| modify it under the terms of this license which you
| can read by viewing the included agpl.txt or online
| at www.gnu.org/licenses/agpl.html. Removal of this
| copyright header is strictly prohibited without
| written permission from the original author(s).
+----------------------------------------------------*/

require_once "../../maincore.php";
require_once THEMES."templates/admin_header.php";

if (!iSUPERADMIN) { redirect(BASEDIR."index.php"); }

include INFUSIONS."terms/infusion_db.php";

if (checkrights("TER")) {
	opentable("Upgrade terminated");
	echo "<center>It appears as if this upgrade has been performed already.<br />\nThe upgrade script will terminate.<br />\nYou are advised to set any administrative rights for the Terms Infusion through Admin Panel -> User Admin -> Administrators.<br />\nGo to <a href='".BASEDIR."administration/index.php".$aidlink."'>Admin Index</a>.</center>\n";
	closetable();
}
else {

	$dsettings = dbarray(dbquery("SELECT * FROM ".DB_TERM_SETTINGS.""));
	$usergroup = $dsettings['term_usergroup'];

	if (isset($_POST['all_supers']) || isset($_GET['all_supers'])) {
		$all_supers = (isset($_GET['all_supers']) ? $_GET['all_supers'] : $_POST['all_supers']);
	} else { $all_supers = "0"; }

	if (isset($_POST['all_admins']) || isset($_GET['all_admins'])) {
		$all_admins = (isset($_GET['all_admins']) ? $_GET['all_admins'] : $_POST['all_admins']);
	} else { $all_admins = "0"; }

	if (isset($_POST['all_usergroup']) || isset($_GET['all_usergroup'])) {
		$all_usergroup = (isset($_GET['all_usergroup']) ? $_GET['all_usergroup'] : $_POST['all_usergroup']);
	} else { $all_usergroup = "0"; }

	if (isset($_POST['upgrade'])) {
		opentable("Upgrade performed");
		echo "<table border='0' cellpadding='0'cellspacing='0' width='600' align='center'>\n";
			echo "<tr><td class='tbl' align='center'>\n";

			// adding rights for primary superadmin
		$result = dbquery("SELECT user_id, user_rights, user_name FROM ".DB_USERS." WHERE user_level='103' AND user_id='1'");
		while ($data = dbarray($result)) {
			$results = dbquery("UPDATE ".DB_USERS." SET user_rights='".$data['user_rights'].".TER' WHERE user_id='1'");
			echo "Primary Superadmin ".$data['user_name']." updated.<br />"; 
		}

// adding rights for non-primary superadmins
		if ($all_supers == '1') {
			$result = dbquery("SELECT user_name, user_id, user_rights FROM ".DB_USERS." WHERE user_level='103' AND user_id!='1'");
			while ($data = dbarray($result)) {
//				$result2 = dbquery("UPDATE ".DB_USERS." SET user_rights='".$data['user_rights'].".TER' WHERE user_id='".$data['user_id']."'");
				echo "Superadmin ".$data['user_name']." updated.<br />"; 
			}
		}

// adding rights admins for existing admin
		if ($all_admins == '1') {
			$result = dbquery("SELECT * FROM ".DB_USER_GROUPS." WHERE group_id='".$usergroup."'");
			if (dbrows($result)) {
				$data = dbarray($result);
				$result = dbquery("SELECT * FROM ".DB_USERS." WHERE user_level='102' AND user_groups REGEXP('^\\\.{$usergroup}$|\\\.{$usergroup}\\\.|\\\.{$usergroup}$') ORDER BY user_name");
				if (dbrows($result)) {
					while ($data = dbarray($result)) {
						$result2 = dbquery("UPDATE ".DB_USERS." SET user_rights='".$data['user_rights'].".TER' WHERE user_id='".$data['user_id']."'");
						echo "Admin ".$data['user_name']." updated.<br />"; 
					}
				}
				else {
					echo "There were no regular Admins that were designated administration rights for the Terms Infusion.<br />";
				}
			}
		}

// adding rights admins for usergroup members
		if ($all_usergroup == '1') {
			$result = dbquery("SELECT * FROM ".DB_USER_GROUPS." WHERE group_id='".$usergroup."'");
			if (dbrows($result)) {
				$data = dbarray($result);
				$result = dbquery("SELECT * FROM ".DB_USERS." WHERE user_level='101' AND user_groups REGEXP('^\\\.{$usergroup}$|\\\.{$usergroup}\\\.|\\\.{$usergroup}$') ORDER BY user_name");
				if (dbrows($result)) {
					while ($data = dbarray($result)) {
						$result2 = dbquery("UPDATE ".DB_USERS." SET user_level='102', user_rights='TER' WHERE user_id='".$data['user_id']."'");
						echo "Member ".$data['user_name']." upgraded to Admin with administration rights for Terms Infusion.<br />"; 
					}
				}
				else {
					echo "There were no regular members in the usergroup<br />that was designated administration rights for the Terms Infusion.<br />";
				}
			}
		}
		$result = dbquery("ALTER TABLE ".DB_TERM_SETTINGS." ADD term_version VARCHAR(5) NOT NULL DEFAULT '3.00' FIRST");
		$result = dbquery("ALTER TABLE ".DB_TERM_SETTINGS." ADD term_listdisplay TINYINT(1) NOT NULL DEFAULT '0'");
		$result = dbquery("ALTER TABLE ".DB_TERM_SETTINGS." DROP term_usergroup");
		echo "Return to <a href='".BASEDIR."administration/index.php".$aidlink."'>Admin Index</a>";
		echo "</td></tr>\n</table>";
		closetable();
	}

	else {
		opentable("Upgrade Terms Infusion from PHP-Fusion v6 to PHP-Fusion v7");
		echo "<form ENCTYPE='multipart/form-data' name='inputform' method='post' action='".FUSION_SELF."'>\n";
		echo "<table border='0' cellpadding='3' cellspacing='1' width='600' align='center'>\n";
		echo "<tr><td colspan='2' class='tbl' align='center'><strong>Please check the required boxes.</strong><br />Set admin rights for Terms Infusion for:</td></tr>\n"; 
		echo "<tr><td class='tbl1' align='right' width='75%'>ALL Superadmins (not just Primary Superadmin): </td>\n";
		echo "<td class='tbl1' align='left'><input type='checkbox' name='all_supers' value='1' /></td></tr>\n";
		echo "<tr><td class='tbl1' align='right'>ALL Admins with administration rights to Terms Infusion: </td>\n";
		echo "<td class='tbl1' align='left'><input type='checkbox' name='all_admins' value='1' /></td></tr>\n";
		echo "<tr><td class='tbl1' align='right'>ALL Members in usergroup with administration rights to Terms Infusion: </td>\n";
		echo "<td class='tbl1' align='left'><input type='checkbox' name='all_usergroup' value='1' /></td></tr>\n";
		echo "<tr><td align='center' colspan='2' class='tbl1'><span class='small'>Please be advised that upgrading Members to Admins<br />\nwill result in giving them all default rights awarded to Admins.</class></td></tr>\n";
		echo "<tr><td align='center' colspan='2' class='tbl1'>\n";
		echo "<input type='submit' name='upgrade' value='Upgrade' class='button' /></td></tr>\n";
		echo "</table>\n";
		echo "</form>\n";
		closetable();
	}
}

require_once THEMES."templates/footer.php";
?>